/* (C) Copyright 2008 Bill Buckels */

/* main menu module */

#include "me2.h"

/* worm cursor coordinates */
/* the menu is divided into 13, 14, 13 in the xaxis */
int cursorx[3] = { 2, 15, 29};
int cursory[2] = { 32, 112};

/* derive the x,y cordinates for the worm cursor
   from the menu position */
int cursorpos(pos, x, y)
int pos, *x, *y;
{

	switch(pos) {

	   case 5:  x[0] = cursorx[2]; y[0] = cursory[1]; break;
	   case 4:  x[0] = cursorx[1]; y[0] = cursory[1]; break;
	   case 3:  x[0] = cursorx[0]; y[0] = cursory[1]; break;
	   case 2:  x[0] = cursorx[2]; y[0] = cursory[0]; break;
	   case 1:  x[0] = cursorx[1]; y[0] = cursory[0]; break;
	   case 0:
	   default: x[0] = cursorx[0]; y[0] = cursory[0]; break;

	}
	return pos;

}

ovmain(position)
int position;
{

   int c,newx,newy,oldx,oldy,arrowflag;
   int x1, x2, y3;

   /* set the startup flag and save the screen beneath position 0  */
   /* then put the first worm in place and move him based on the  */
   /* keys that are pressed                                        */
   /* return the position at the cursor if enter is pressed        */

   /* the cursor library must be reloaded each time the main menu
      is initialized since the memory is re-used as a read-buffer
      by other modules */
   liblode("CURSORS.RIB",CURSORS_SIZE);

   cursorpos(position, &newx, &newy);

   oldx = newx;
   oldy = newy;

   /* determine mouse boundaries for cursor positioning
      based on mouse resolution */
   x1 = MXMAX /3;
   x2 = MXMAX - x1;
   y3 = MYMAX / 2;

   /* disable mouse positioning the first arrow keypress
      each time the menu is displayed.
      but always allow mouse button click to emulate spacebar key.

      the escape key must always be from the keyboard */

   arrowflag = 0;

  /* if a mouse is in use set the
     initial position based on the mouse */
   if (mouseflag == 0) {
	    cmouse();
   		position = 0;
   		if (mousex > x1) position =  1;
   		if (mousex > x2) position =  2;
   		if (mousey > y3) position += 3;
   		cursorpos(position, &newx, &newy);
   		oldx=newx;oldy=newy;
	}

   putimage(WORMBACK,WORM_WIDTH,WORM_HEIGHT,newx,newy,GET);
   if(position == 0 || position == 3)
      putimage(LEFTWORM,WORM_WIDTH,WORM_HEIGHT,
      newx,newy,P_AND);
   else
      putimage(RIGHTWORM,WORM_WIDTH,WORM_HEIGHT,
      newx,newy,P_AND);
   noteworthy(1);


   while (kbhit())kbclear();

   for (;;) {

	   c = kbhit();
	   if (c!=0)kbclear();

       if (c == ESCKEY) break;

        switch(c)
        {
            case SIX       :  multiples = 6;break;
            case THREE     :  multiples = 3;break;
            case SOUNDKEY  :  noteworthy(0);   break;


            case SPACEBAR  :
            case ENTERKEY  :
                              return position;


            case UPARROW   :
            case DOWNARROW :
            case LEFTARROW :
            case RIGHTARROW:  /* respond to arrow keys */
                              /* disable mouse positioning
                                 if arrow keys are used */
                              arrowflag = 1;

                              if(c==UPARROW) {
								  position-=3;
								  if (position < 0)position+=6;
							  }
                              if(c==DOWNARROW) {
								  position += 3;
								  if (position > 5) position-=6;
							  }
                              if(c==LEFTARROW ) {
							      position-=1;
							      if (position < 0)position = 5;
							  }
                              if(c==RIGHTARROW) {
								  position += 1;
								  if (position > 5)position = 0;
							  }
							  break;

		    default:          if (mouseflag != 0 || arrowflag != 0) break;
		                      position = 0;
		                      if (mousex > x1) position =  1;
		                      if (mousex > x2) position =  2;
		                      if (mousey > y3) position += 3;

		}

		  cursorpos(position, &newx, &newy);

		  /* update screen for arrow key change */
		  /* and mouse position change */
		  if(newy!=oldy || newx != oldx)
		  {
		  /* restore the screen */
		  putimage(WORMBACK,WORM_WIDTH,WORM_HEIGHT,
						   oldx,oldy,PUT);
		  /* store the screen */
		  putimage(WORMBACK,WORM_WIDTH,WORM_HEIGHT,
						   newx,newy,GET);
		  if(position == 0 || position == 3)
			 putimage(LEFTWORM,WORM_WIDTH,WORM_HEIGHT,
							 newx,newy,P_AND);
		  else
			 putimage(RIGHTWORM,WORM_WIDTH,WORM_HEIGHT,
							 newx,newy,P_AND);
			 oldx=newx;oldy=newy;
		  }


   }

   while (kbhit())kbclear();

return 5; /* return the 6th position if ESCAPE is pressed */
}
